/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dI18N;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector4d;

class CachedFrustum {
    static final double EPSILON = 1.0E-6;
    Vector4d[] clipPlanes;
    Point3d[] verts;
    Point4d[] xEdges;
    Point4d[] yEdges;
    Point4d[] zEdges;
    int nxEdges;
    int nyEdges;
    int nzEdges;
    int[] xEdgeList;
    int[] yEdgeList;
    int[] zEdgeList;
    Point3d upper;
    Point3d lower;
    Point3d center;
    Point3d edge = new Point3d();

    CachedFrustum(Vector4d[] vector4dArray) {
        if (vector4dArray.length < 6) {
            throw new IllegalArgumentException(J3dI18N.getString("CachedFrustum0"));
        }
        this.clipPlanes = new Vector4d[6];
        this.xEdges = new Point4d[12];
        this.yEdges = new Point4d[12];
        this.zEdges = new Point4d[12];
        this.verts = new Point3d[8];
        this.upper = new Point3d();
        this.lower = new Point3d();
        this.xEdgeList = new int[12];
        this.yEdgeList = new int[12];
        this.zEdgeList = new int[12];
        this.center = new Point3d();
        int n = 0;
        while (n < 8) {
            this.verts[n] = new Point3d();
            ++n;
        }
        n = 0;
        while (n < 6) {
            this.clipPlanes[n] = new Vector4d(vector4dArray[n]);
            ++n;
        }
        n = 0;
        while (n < 12) {
            this.xEdges[n] = new Point4d();
            this.yEdges[n] = new Point4d();
            this.zEdges[n] = new Point4d();
            ++n;
        }
        this.computeValues(this.clipPlanes);
    }

    CachedFrustum() {
        this.clipPlanes = new Vector4d[6];
        this.upper = new Point3d();
        this.lower = new Point3d();
        this.xEdges = new Point4d[12];
        this.yEdges = new Point4d[12];
        this.zEdges = new Point4d[12];
        this.verts = new Point3d[8];
        this.xEdgeList = new int[12];
        this.yEdgeList = new int[12];
        this.zEdgeList = new int[12];
        this.center = new Point3d();
        int n = 0;
        while (n < 8) {
            this.verts[n] = new Point3d();
            ++n;
        }
        n = 0;
        while (n < 6) {
            this.clipPlanes[n] = new Vector4d();
            ++n;
        }
        n = 0;
        while (n < 12) {
            this.xEdges[n] = new Point4d();
            this.yEdges[n] = new Point4d();
            this.zEdges[n] = new Point4d();
            ++n;
        }
    }

    public String toString() {
        return this.clipPlanes[0].toString() + "\n" + this.clipPlanes[1].toString() + "\n" + this.clipPlanes[2].toString() + "\n" + this.clipPlanes[3].toString() + "\n" + this.clipPlanes[4].toString() + "\n" + this.clipPlanes[5].toString() + "\n" + "corners=" + "\n" + this.verts[0].toString() + "\n" + this.verts[1].toString() + "\n" + this.verts[2].toString() + "\n" + this.verts[3].toString() + "\n" + this.verts[4].toString() + "\n" + this.verts[5].toString() + "\n" + this.verts[6].toString() + "\n" + this.verts[7].toString();
    }

    void set(Vector4d[] vector4dArray) {
        if (vector4dArray.length != 6) {
            throw new IllegalArgumentException(J3dI18N.getString("CachedFrustum1"));
        }
        int n = 0;
        while (n < 6) {
            this.clipPlanes[n].set((Tuple4d)vector4dArray[n]);
            ++n;
        }
        this.computeValues(this.clipPlanes);
    }

    private void computeValues(Vector4d[] vector4dArray) {
        this.computeVertex(0, 3, 4, this.verts[0]);
        this.computeVertex(0, 2, 4, this.verts[1]);
        this.computeVertex(1, 2, 4, this.verts[2]);
        this.computeVertex(1, 3, 4, this.verts[3]);
        this.computeVertex(0, 3, 5, this.verts[4]);
        this.computeVertex(0, 2, 5, this.verts[5]);
        this.computeVertex(1, 2, 5, this.verts[6]);
        this.computeVertex(1, 3, 5, this.verts[7]);
        this.upper.x = this.verts[0].x;
        this.upper.y = this.verts[0].y;
        this.upper.z = this.verts[0].z;
        this.lower.x = this.verts[0].x;
        this.lower.y = this.verts[0].y;
        this.lower.z = this.verts[0].z;
        this.center.x = this.verts[0].x;
        this.center.y = this.verts[0].y;
        this.center.z = this.verts[0].z;
        int n = 1;
        while (n < 8) {
            if (this.verts[n].x > this.upper.x) {
                this.upper.x = this.verts[n].x;
            }
            if (this.verts[n].x < this.lower.x) {
                this.lower.x = this.verts[n].x;
            }
            if (this.verts[n].y > this.upper.y) {
                this.upper.y = this.verts[n].y;
            }
            if (this.verts[n].y < this.lower.y) {
                this.lower.y = this.verts[n].y;
            }
            if (this.verts[n].z > this.upper.z) {
                this.upper.z = this.verts[n].z;
            }
            if (this.verts[n].z < this.lower.z) {
                this.lower.z = this.verts[n].z;
            }
            this.center.x += this.verts[n].x;
            this.center.y += this.verts[n].y;
            this.center.z += this.verts[n].z;
            ++n;
        }
        this.center.x *= 0.125;
        this.center.y *= 0.125;
        this.center.z *= 0.125;
        n = 0;
        if (this.clipPlanes[0].y * this.clipPlanes[4].y <= 0.0) {
            this.yEdgeList[n++] = 0;
        }
        if (this.clipPlanes[2].y * this.clipPlanes[4].y <= 0.0) {
            this.yEdgeList[n++] = 1;
        }
        if (this.clipPlanes[1].y * this.clipPlanes[4].y <= 0.0) {
            this.yEdgeList[n++] = 2;
        }
        if (this.clipPlanes[3].y * this.clipPlanes[4].y <= 0.0) {
            this.yEdgeList[n++] = 3;
        }
        if (this.clipPlanes[0].y * this.clipPlanes[3].y <= 0.0) {
            this.yEdgeList[n++] = 4;
        }
        if (this.clipPlanes[0].y * this.clipPlanes[2].y <= 0.0) {
            this.yEdgeList[n++] = 5;
        }
        if (this.clipPlanes[1].y * this.clipPlanes[2].y <= 0.0) {
            this.yEdgeList[n++] = 6;
        }
        if (this.clipPlanes[1].y * this.clipPlanes[3].y <= 0.0) {
            this.yEdgeList[n++] = 7;
        }
        if (this.clipPlanes[0].y * this.clipPlanes[5].y <= 0.0) {
            this.yEdgeList[n++] = 8;
        }
        if (this.clipPlanes[2].y * this.clipPlanes[5].y <= 0.0) {
            this.yEdgeList[n++] = 9;
        }
        if (this.clipPlanes[1].y * this.clipPlanes[5].y <= 0.0) {
            this.yEdgeList[n++] = 10;
        }
        if (this.clipPlanes[3].y * this.clipPlanes[5].y <= 0.0) {
            this.yEdgeList[n++] = 11;
        }
        this.nyEdges = n;
        n = 0;
        if (this.clipPlanes[0].x * this.clipPlanes[4].x <= 0.0) {
            this.xEdgeList[n++] = 0;
        }
        if (this.clipPlanes[2].x * this.clipPlanes[4].x <= 0.0) {
            this.xEdgeList[n++] = 1;
        }
        if (this.clipPlanes[1].x * this.clipPlanes[4].x <= 0.0) {
            this.xEdgeList[n++] = 2;
        }
        if (this.clipPlanes[3].x * this.clipPlanes[4].x <= 0.0) {
            this.xEdgeList[n++] = 3;
        }
        if (this.clipPlanes[0].x * this.clipPlanes[3].x <= 0.0) {
            this.xEdgeList[n++] = 4;
        }
        if (this.clipPlanes[0].x * this.clipPlanes[2].x <= 0.0) {
            this.xEdgeList[n++] = 5;
        }
        if (this.clipPlanes[1].x * this.clipPlanes[2].x <= 0.0) {
            this.xEdgeList[n++] = 6;
        }
        if (this.clipPlanes[1].x * this.clipPlanes[3].x <= 0.0) {
            this.xEdgeList[n++] = 7;
        }
        if (this.clipPlanes[0].x * this.clipPlanes[5].x <= 0.0) {
            this.xEdgeList[n++] = 8;
        }
        if (this.clipPlanes[2].x * this.clipPlanes[5].x <= 0.0) {
            this.xEdgeList[n++] = 9;
        }
        if (this.clipPlanes[1].x * this.clipPlanes[5].x <= 0.0) {
            this.xEdgeList[n++] = 10;
        }
        if (this.clipPlanes[3].x * this.clipPlanes[5].x <= 0.0) {
            this.xEdgeList[n++] = 11;
        }
        this.nxEdges = n;
        n = 0;
        if (this.clipPlanes[0].z * this.clipPlanes[4].z <= 0.0) {
            this.zEdgeList[n++] = 0;
        }
        if (this.clipPlanes[2].z * this.clipPlanes[4].z <= 0.0) {
            this.zEdgeList[n++] = 1;
        }
        if (this.clipPlanes[1].z * this.clipPlanes[4].z <= 0.0) {
            this.zEdgeList[n++] = 2;
        }
        if (this.clipPlanes[3].z * this.clipPlanes[4].z <= 0.0) {
            this.zEdgeList[n++] = 3;
        }
        if (this.clipPlanes[0].z * this.clipPlanes[3].z <= 0.0) {
            this.zEdgeList[n++] = 4;
        }
        if (this.clipPlanes[0].z * this.clipPlanes[2].z <= 0.0) {
            this.zEdgeList[n++] = 5;
        }
        if (this.clipPlanes[1].z * this.clipPlanes[2].z <= 0.0) {
            this.zEdgeList[n++] = 6;
        }
        if (this.clipPlanes[1].z * this.clipPlanes[3].z <= 0.0) {
            this.zEdgeList[n++] = 7;
        }
        if (this.clipPlanes[0].z * this.clipPlanes[5].z <= 0.0) {
            this.zEdgeList[n++] = 8;
        }
        if (this.clipPlanes[2].z * this.clipPlanes[5].z <= 0.0) {
            this.zEdgeList[n++] = 9;
        }
        if (this.clipPlanes[1].z * this.clipPlanes[5].z <= 0.0) {
            this.zEdgeList[n++] = 10;
        }
        if (this.clipPlanes[3].z * this.clipPlanes[5].z <= 0.0) {
            this.zEdgeList[n++] = 11;
        }
        this.nzEdges = n;
        this.computeEdges(this.clipPlanes, 0, 4, this.xEdges[0], this.yEdges[0], this.zEdges[0]);
        this.computeEdges(this.clipPlanes, 2, 4, this.xEdges[1], this.yEdges[1], this.zEdges[1]);
        this.computeEdges(this.clipPlanes, 1, 4, this.xEdges[2], this.yEdges[2], this.zEdges[2]);
        this.computeEdges(this.clipPlanes, 3, 4, this.xEdges[3], this.yEdges[3], this.zEdges[3]);
        this.computeEdges(this.clipPlanes, 0, 3, this.xEdges[4], this.yEdges[4], this.zEdges[4]);
        this.computeEdges(this.clipPlanes, 0, 2, this.xEdges[5], this.yEdges[5], this.zEdges[5]);
        this.computeEdges(this.clipPlanes, 1, 2, this.xEdges[6], this.yEdges[6], this.zEdges[6]);
        this.computeEdges(this.clipPlanes, 1, 3, this.xEdges[7], this.yEdges[7], this.zEdges[7]);
        this.computeEdges(this.clipPlanes, 0, 5, this.xEdges[8], this.yEdges[8], this.zEdges[8]);
        this.computeEdges(this.clipPlanes, 2, 5, this.xEdges[9], this.yEdges[9], this.zEdges[9]);
        this.computeEdges(this.clipPlanes, 1, 5, this.xEdges[10], this.yEdges[10], this.zEdges[10]);
        this.computeEdges(this.clipPlanes, 3, 5, this.xEdges[11], this.yEdges[11], this.zEdges[11]);
    }

    private void computeEdges(Vector4d[] vector4dArray, int n, int n2, Point4d point4d, Point4d point4d2, Point4d point4d3) {
        double d;
        double d2;
        double d3;
        this.edge.x = vector4dArray[n].y * vector4dArray[n2].z - vector4dArray[n2].y * vector4dArray[n].z;
        this.edge.y = vector4dArray[n2].x * vector4dArray[n].z - vector4dArray[n].x * vector4dArray[n2].z;
        this.edge.z = vector4dArray[n].x * vector4dArray[n2].y - vector4dArray[n2].x * vector4dArray[n].y;
        double d4 = 1.0 / Math.sqrt(this.edge.x * this.edge.x + this.edge.y * this.edge.y + this.edge.z * this.edge.z);
        this.edge.x = d4 * this.edge.x;
        this.edge.y = d4 * this.edge.y;
        this.edge.z = d4 * this.edge.z;
        double d5 = Math.abs(this.edge.x);
        double d6 = Math.abs(this.edge.y);
        double d7 = Math.abs(this.edge.z);
        if (d7 >= d5 && d7 >= d6) {
            double d8 = vector4dArray[n].x * vector4dArray[n2].y + vector4dArray[n].z * vector4dArray[n2].y;
            d8 = d8 == 0.0 ? 1.0 : 1.0 / d8;
            d3 = (vector4dArray[n].y * vector4dArray[n2].w - vector4dArray[n2].y * vector4dArray[n].w) * d8;
            d2 = (vector4dArray[n2].x * vector4dArray[n].w - vector4dArray[n].x * vector4dArray[n2].w) * d8;
            d = 0.0;
        } else if (d5 >= d6 && d5 >= d7) {
            double d9 = vector4dArray[n].y * vector4dArray[n2].z + vector4dArray[n].z * vector4dArray[n2].y;
            d9 = d9 == 0.0 ? 1.0 : 1.0 / d9;
            d3 = 0.0;
            d2 = (vector4dArray[n].z * vector4dArray[n2].w - vector4dArray[n2].z * vector4dArray[n].w) * d9;
            d = (vector4dArray[n2].y * vector4dArray[n].w - vector4dArray[n].y * vector4dArray[n2].w) * d9;
        } else {
            double d10 = vector4dArray[n].x * vector4dArray[n2].z + vector4dArray[n].z * vector4dArray[n2].x;
            d10 = d10 == 0.0 ? 1.0 : 1.0 / d10;
            d3 = (vector4dArray[n].z * vector4dArray[n2].w - vector4dArray[n2].z * vector4dArray[n].w) * d10;
            d2 = 0.0;
            d = (vector4dArray[n2].x * vector4dArray[n].w - vector4dArray[n].x * vector4dArray[n2].w) * d10;
        }
        point4d.x = 0.0;
        point4d.y = -this.edge.z;
        point4d.z = this.edge.y;
        point4d.w = -(point4d.y * d2 + point4d.z * d);
        if (this.center.y * point4d.y + this.center.z * point4d.z + point4d.w > 0.0) {
            point4d.y = this.edge.z;
            point4d.z = -this.edge.y;
            point4d.w = -(point4d.y * d2 + point4d.z * d);
        }
        point4d2.x = -this.edge.z;
        point4d2.y = 0.0;
        point4d2.z = this.edge.x;
        point4d2.w = -(point4d2.x * d3 + point4d2.z * d);
        if (this.center.y * point4d2.y + this.center.z * point4d2.z + point4d2.w > 0.0) {
            point4d2.x = this.edge.z;
            point4d2.z = -this.edge.x;
            point4d2.w = -(point4d2.x * d3 + point4d2.z * d);
        }
        point4d3.x = -this.edge.y;
        point4d3.y = this.edge.x;
        point4d3.z = 0.0;
        point4d3.w = -(point4d3.y * d2 + point4d3.x * d3);
        if (this.center.x * point4d3.x + this.center.y * point4d3.y + point4d3.w > 0.0) {
            point4d3.x = this.edge.y;
            point4d3.y = -this.edge.x;
            point4d3.w = -(point4d3.y * d2 + point4d3.x * d3);
        }
    }

    private void computeVertex(int n, int n2, int n3, Point3d point3d) {
        double d = this.clipPlanes[n].x * this.clipPlanes[n2].y * this.clipPlanes[n3].z + this.clipPlanes[n].y * this.clipPlanes[n2].z * this.clipPlanes[n3].x + this.clipPlanes[n].z * this.clipPlanes[n2].x * this.clipPlanes[n3].y - this.clipPlanes[n].z * this.clipPlanes[n2].y * this.clipPlanes[n3].x - this.clipPlanes[n].y * this.clipPlanes[n2].x * this.clipPlanes[n3].z - this.clipPlanes[n].x * this.clipPlanes[n2].z * this.clipPlanes[n3].y;
        if (d * d < 1.0E-6) {
            return;
        }
        d = 1.0 / d;
        point3d.x = (this.clipPlanes[n2].y * this.clipPlanes[n3].z - this.clipPlanes[n2].z * this.clipPlanes[n3].y) * -this.clipPlanes[n].w;
        point3d.y = (this.clipPlanes[n2].z * this.clipPlanes[n3].x - this.clipPlanes[n2].x * this.clipPlanes[n3].z) * -this.clipPlanes[n].w;
        point3d.z = (this.clipPlanes[n2].x * this.clipPlanes[n3].y - this.clipPlanes[n2].y * this.clipPlanes[n3].x) * -this.clipPlanes[n].w;
        point3d.x += (this.clipPlanes[n3].y * this.clipPlanes[n].z - this.clipPlanes[n3].z * this.clipPlanes[n].y) * -this.clipPlanes[n2].w;
        point3d.y += (this.clipPlanes[n3].z * this.clipPlanes[n].x - this.clipPlanes[n3].x * this.clipPlanes[n].z) * -this.clipPlanes[n2].w;
        point3d.z += (this.clipPlanes[n3].x * this.clipPlanes[n].y - this.clipPlanes[n3].y * this.clipPlanes[n].x) * -this.clipPlanes[n2].w;
        point3d.x += (this.clipPlanes[n].y * this.clipPlanes[n2].z - this.clipPlanes[n].z * this.clipPlanes[n2].y) * -this.clipPlanes[n3].w;
        point3d.y += (this.clipPlanes[n].z * this.clipPlanes[n2].x - this.clipPlanes[n].x * this.clipPlanes[n2].z) * -this.clipPlanes[n3].w;
        point3d.z += (this.clipPlanes[n].x * this.clipPlanes[n2].y - this.clipPlanes[n].y * this.clipPlanes[n2].x) * -this.clipPlanes[n3].w;
        point3d.x *= d;
        point3d.y *= d;
        point3d.z *= d;
    }

    boolean intersect(double d, double d2, double d3, double d4, double d5, double d6) {
        int n;
        if (!(d4 > this.lower.x && d < this.upper.x && d5 > this.lower.y && d2 < this.upper.y && d6 > this.lower.z && d3 < this.upper.z)) {
            return false;
        }
        int n2 = 0;
        while (n2 < 6) {
            if (!(d4 * this.clipPlanes[n2].x + d5 * this.clipPlanes[n2].y + d6 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6 || d4 * this.clipPlanes[n2].x + d2 * this.clipPlanes[n2].y + d6 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6 || d4 * this.clipPlanes[n2].x + d2 * this.clipPlanes[n2].y + d3 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6 || d4 * this.clipPlanes[n2].x + d5 * this.clipPlanes[n2].y + d3 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6 || d * this.clipPlanes[n2].x + d5 * this.clipPlanes[n2].y + d6 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6 || d * this.clipPlanes[n2].x + d2 * this.clipPlanes[n2].y + d6 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6 || d * this.clipPlanes[n2].x + d2 * this.clipPlanes[n2].y + d3 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6 || d * this.clipPlanes[n2].x + d5 * this.clipPlanes[n2].y + d3 * this.clipPlanes[n2].z + this.clipPlanes[n2].w > -1.0E-6)) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nxEdges) {
            n = this.xEdgeList[n2];
            if (d5 * this.xEdges[n].y + d6 * this.xEdges[n].z + this.xEdges[n].w < 1.0E-6 || d5 * this.xEdges[n].y + d3 * this.xEdges[n].z + this.xEdges[n].w < 1.0E-6 || d2 * this.xEdges[n].y + d6 * this.xEdges[n].z + this.xEdges[n].w < 1.0E-6 || d2 * this.xEdges[n].y + d3 * this.xEdges[n].z + this.xEdges[n].w < 1.0E-6) break;
            if (n2 == this.nxEdges - 1) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nyEdges) {
            n = this.yEdgeList[n2];
            if (d4 * this.yEdges[n].x + d6 * this.yEdges[n].z + this.yEdges[n].w < 1.0E-6 || d4 * this.yEdges[n].x + d3 * this.yEdges[n].z + this.yEdges[n].w < 1.0E-6 || d * this.yEdges[n].x + d6 * this.yEdges[n].z + this.yEdges[n].w < 1.0E-6 || d * this.yEdges[n].x + d3 * this.yEdges[n].z + this.yEdges[n].w < 1.0E-6) break;
            if (n2 == this.nyEdges - 1) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nzEdges) {
            n = this.zEdgeList[n2];
            if (d5 * this.zEdges[n].y + d6 * this.zEdges[n].z + this.zEdges[n].w < 1.0E-6 || d5 * this.zEdges[n].y + d3 * this.zEdges[n].z + this.zEdges[n].w < 1.0E-6 || d2 * this.zEdges[n].y + d6 * this.zEdges[n].z + this.zEdges[n].w < 1.0E-6 || d2 * this.zEdges[n].y + d3 * this.zEdges[n].z + this.zEdges[n].w < 1.0E-6) break;
            if (n2 == this.nzEdges - 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

