/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.algorithms.util.MapSettableTransformer;
import edu.uci.ics.jung.algorithms.util.SettableTransformer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.io.GraphMLMetadata;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.bidimap.DualHashBidiMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMLReader<G extends Hypergraph<V, E>, V, E>
extends DefaultHandler {
    protected SAXParser saxp;
    protected EdgeType default_edgetype;
    protected G current_graph;
    protected V current_vertex = null;
    protected E current_edge = null;
    protected String current_key;
    protected LinkedList<TagState> current_states;
    protected BidiMap<String, TagState> tag_state;
    protected Factory<G> graph_factory;
    protected Factory<V> vertex_factory;
    protected Factory<E> edge_factory;
    protected BidiMap<V, String> vertex_ids;
    protected BidiMap<E, String> edge_ids;
    protected Map<String, GraphMLMetadata<G>> graph_metadata;
    protected Map<String, GraphMLMetadata<V>> vertex_metadata;
    protected Map<String, GraphMLMetadata<E>> edge_metadata;
    protected Map<V, String> vertex_desc;
    protected Map<E, String> edge_desc;
    protected Map<G, String> graph_desc;
    protected KeyType key_type;
    protected Collection<V> hyperedge_vertices;
    protected List<G> graphs;
    protected StringBuilder current_text = new StringBuilder();

    public GraphMLReader(Factory<V> vertex_factory, Factory<E> edge_factory) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.saxp = factory.newSAXParser();
        this.current_states = new LinkedList();
        this.tag_state = new DualHashBidiMap<String, TagState>();
        this.tag_state.put("node", TagState.VERTEX);
        this.tag_state.put("edge", TagState.EDGE);
        this.tag_state.put("hyperedge", TagState.HYPEREDGE);
        this.tag_state.put("endpoint", TagState.ENDPOINT);
        this.tag_state.put("graph", TagState.GRAPH);
        this.tag_state.put("data", TagState.DATA);
        this.tag_state.put("key", TagState.KEY);
        this.tag_state.put("desc", TagState.DESC);
        this.tag_state.put("default", TagState.DEFAULT_KEY);
        this.tag_state.put("graphml", TagState.GRAPHML);
        this.key_type = KeyType.NONE;
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
    }

    public GraphMLReader() throws ParserConfigurationException, SAXException {
        this(null, null);
    }

    public List<G> loadMultiple(Reader reader, Factory<G> graph_factory) throws IOException {
        this.graph_factory = graph_factory;
        this.initializeData();
        this.clearData();
        this.parse(reader);
        return this.graphs;
    }

    public List<G> loadMultiple(String filename, Factory<G> graph_factory) throws IOException {
        return this.loadMultiple(new FileReader(filename), graph_factory);
    }

    public void load(Reader reader, G g) throws IOException {
        this.current_graph = g;
        this.graph_factory = null;
        this.initializeData();
        this.clearData();
        this.parse(reader);
    }

    public void load(String filename, G g) throws IOException {
        this.load(new FileReader(filename), g);
    }

    protected void clearData() {
        this.vertex_ids.clear();
        this.vertex_desc.clear();
        this.edge_ids.clear();
        this.edge_desc.clear();
        this.graph_desc.clear();
        this.hyperedge_vertices.clear();
    }

    protected void initializeData() {
        this.vertex_ids = new DualHashBidiMap<V, String>();
        this.vertex_desc = new HashMap<V, String>();
        this.vertex_metadata = new HashMap<String, GraphMLMetadata<V>>();
        this.edge_ids = new DualHashBidiMap<E, String>();
        this.edge_desc = new HashMap<E, String>();
        this.edge_metadata = new HashMap<String, GraphMLMetadata<E>>();
        this.graph_desc = new HashMap<G, String>();
        this.graph_metadata = new HashMap<String, GraphMLMetadata<G>>();
        this.hyperedge_vertices = new ArrayList<V>();
    }

    protected void parse(Reader reader) throws IOException {
        try {
            this.saxp.parse(new InputSource(reader), (DefaultHandler)this);
            reader.close();
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXNotSupportedException {
        String tag = qName.toLowerCase();
        TagState state = (TagState)((Object)this.tag_state.get(tag));
        if (state == null) {
            state = TagState.OTHER;
        }
        switch (state) {
            case GRAPHML: {
                break;
            }
            case VERTEX: {
                if (this.current_graph == null) {
                    throw new SAXNotSupportedException("Graph must be defined prior to elements");
                }
                if (this.current_edge != null || this.current_vertex != null) {
                    throw new SAXNotSupportedException("Nesting elements not supported");
                }
                this.createVertex(atts);
                break;
            }
            case ENDPOINT: {
                if (this.current_graph == null) {
                    throw new SAXNotSupportedException("Graph must be defined prior to elements");
                }
                if (this.current_edge == null) {
                    throw new SAXNotSupportedException("No edge defined for endpoint");
                }
                if (this.current_states.getFirst() != TagState.HYPEREDGE) {
                    throw new SAXNotSupportedException("Endpoints must be defined inside hyperedge");
                }
                Map<String, String> endpoint_atts = this.getAttributeMap(atts);
                String node = endpoint_atts.remove("node");
                if (node == null) {
                    throw new SAXNotSupportedException("Endpoint must include an 'id' attribute");
                }
                V v = this.vertex_ids.getKey(node);
                if (v == null) {
                    throw new SAXNotSupportedException("Endpoint refers to nonexistent node ID: " + node);
                }
                this.current_vertex = v;
                this.hyperedge_vertices.add(v);
                break;
            }
            case EDGE: 
            case HYPEREDGE: {
                if (this.current_graph == null) {
                    throw new SAXNotSupportedException("Graph must be defined prior to elements");
                }
                if (this.current_edge != null || this.current_vertex != null) {
                    throw new SAXNotSupportedException("Nesting elements not supported");
                }
                this.createEdge(atts, state);
                break;
            }
            case GRAPH: {
                if (this.current_graph != null && this.graph_factory != null) {
                    throw new SAXNotSupportedException("Nesting graphs not currently supported");
                }
                if (this.graph_factory != null) {
                    this.current_graph = (Hypergraph)this.graph_factory.create();
                }
                this.clearData();
                Map<String, String> graph_atts = this.getAttributeMap(atts);
                String default_direction = graph_atts.remove("edgedefault");
                if (default_direction == null) {
                    throw new SAXNotSupportedException("All graphs must specify a default edge direction");
                }
                if (default_direction.equals("directed")) {
                    this.default_edgetype = EdgeType.DIRECTED;
                } else if (default_direction.equals("undirected")) {
                    this.default_edgetype = EdgeType.UNDIRECTED;
                } else {
                    throw new SAXNotSupportedException("Invalid or unrecognized default edge direction: " + default_direction);
                }
                this.addExtraData(graph_atts, this.graph_metadata, this.current_graph);
                break;
            }
            case DATA: {
                if (this.current_states.contains((Object)TagState.DATA)) {
                    throw new SAXNotSupportedException("Nested data not supported");
                }
                this.handleData(atts);
                break;
            }
            case KEY: {
                this.createKey(atts);
                break;
            }
        }
        this.current_states.addFirst(state);
    }

    protected <T> void addExtraData(Map<String, String> atts, Map<String, GraphMLMetadata<T>> metadata_map, T current_elt) {
        for (Map.Entry<String, GraphMLMetadata<T>> entry : metadata_map.entrySet()) {
            GraphMLMetadata<T> gmlm = entry.getValue();
            if (gmlm.default_value == null) continue;
            SettableTransformer st = (SettableTransformer)gmlm.transformer;
            st.set(current_elt, (Object)gmlm.default_value);
        }
        for (Map.Entry<String, Object> entry : atts.entrySet()) {
            SettableTransformer st;
            String key = entry.getKey();
            GraphMLMetadata<T> key_data = metadata_map.get(key);
            if (key_data != null) {
                if (key_data.default_value != null) continue;
                st = (SettableTransformer)key_data.transformer;
            } else {
                st = new MapSettableTransformer(new HashMap());
                key_data = new GraphMLMetadata(null, null, st);
                metadata_map.put(key, key_data);
            }
            st.set(current_elt, entry.getValue());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXNotSupportedException {
        this.current_text.append(new String(ch, start, length));
    }

    protected <T> void addDatum(Map<String, GraphMLMetadata<T>> metadata, T current_elt, String text) throws SAXNotSupportedException {
        if (!metadata.containsKey(this.current_key)) {
            throw new SAXNotSupportedException("key " + this.current_key + " not valid for element " + current_elt);
        }
        SettableTransformer st = (SettableTransformer)metadata.get((Object)this.current_key).transformer;
        st.set(current_elt, (Object)text);
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXNotSupportedException {
        String text = this.current_text.toString().trim();
        this.current_text.setLength(0);
        String tag = qName.toLowerCase();
        TagState state = (TagState)((Object)this.tag_state.get(tag));
        if (state == null) {
            state = TagState.OTHER;
        }
        if (state == TagState.OTHER) {
            return;
        }
        if (state != this.current_states.getFirst()) {
            throw new SAXNotSupportedException("Unbalanced tags: opened " + this.tag_state.getKey((Object)this.current_states.getFirst()) + ", closed " + tag);
        }
        block0 : switch (state) {
            case VERTEX: 
            case ENDPOINT: {
                this.current_vertex = null;
                break;
            }
            case EDGE: {
                this.current_edge = null;
                break;
            }
            case HYPEREDGE: {
                this.current_graph.addEdge(this.current_edge, this.hyperedge_vertices);
                this.hyperedge_vertices.clear();
                this.current_edge = null;
                break;
            }
            case GRAPH: {
                this.current_graph = null;
                break;
            }
            case KEY: {
                this.current_key = null;
                break;
            }
            case DESC: {
                switch (this.current_states.get(1)) {
                    case GRAPH: {
                        this.graph_desc.put(this.current_graph, text);
                        break block0;
                    }
                    case VERTEX: 
                    case ENDPOINT: {
                        this.vertex_desc.put((String)this.current_vertex, text);
                        break block0;
                    }
                    case EDGE: 
                    case HYPEREDGE: {
                        this.edge_desc.put(this.current_edge, text);
                        break block0;
                    }
                    case DATA: {
                        switch (this.key_type) {
                            case GRAPH: {
                                this.graph_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                            case VERTEX: {
                                this.vertex_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                            case EDGE: {
                                this.edge_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                            case ALL: {
                                this.graph_metadata.get((Object)this.current_key).description = text;
                                this.vertex_metadata.get((Object)this.current_key).description = text;
                                this.edge_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                        }
                        throw new SAXNotSupportedException("Invalid key type specified for default: " + (Object)((Object)this.key_type));
                    }
                }
                break;
            }
            case DATA: {
                this.key_type = KeyType.NONE;
                switch (this.current_states.get(1)) {
                    case GRAPH: {
                        this.addDatum(this.graph_metadata, this.current_graph, text);
                        break block0;
                    }
                    case VERTEX: 
                    case ENDPOINT: {
                        this.addDatum(this.vertex_metadata, this.current_vertex, text);
                        break block0;
                    }
                    case EDGE: 
                    case HYPEREDGE: {
                        this.addDatum(this.edge_metadata, this.current_edge, text);
                        break block0;
                    }
                }
                break;
            }
            case DEFAULT_KEY: {
                if (this.current_states.get(1) != TagState.KEY) {
                    throw new SAXNotSupportedException("'default' only defined in context of 'key' tag: stack: " + this.current_states.toString());
                }
                switch (this.key_type) {
                    case GRAPH: {
                        this.graph_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                    case VERTEX: {
                        this.vertex_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                    case EDGE: {
                        this.edge_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                    case ALL: {
                        this.graph_metadata.get((Object)this.current_key).default_value = text;
                        this.vertex_metadata.get((Object)this.current_key).default_value = text;
                        this.edge_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                }
                throw new SAXNotSupportedException("Invalid key type specified for default: " + (Object)((Object)this.key_type));
            }
        }
        this.current_states.removeFirst();
    }

    protected Map<String, String> getAttributeMap(Attributes atts) {
        HashMap<String, String> att_map = new HashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            att_map.put(atts.getQName(i), atts.getValue(i));
        }
        return att_map;
    }

    protected void handleData(Attributes atts) throws SAXNotSupportedException {
        switch (this.current_states.getFirst()) {
            case GRAPH: {
                break;
            }
            case VERTEX: 
            case ENDPOINT: {
                break;
            }
            case EDGE: {
                break;
            }
            case HYPEREDGE: {
                break;
            }
            default: {
                throw new SAXNotSupportedException("'data' tag only defined if immediately containing tag is 'graph', 'node', 'edge', or 'hyperedge'");
            }
        }
        this.current_key = this.getAttributeMap(atts).get("key");
        if (this.current_key == null) {
            throw new SAXNotSupportedException("'data' tag requires a key specification");
        }
        if (this.current_key.equals("")) {
            throw new SAXNotSupportedException("'data' tag requires a non-empty key");
        }
        if (!(this.getGraphMetadata().containsKey(this.current_key) || this.getVertexMetadata().containsKey(this.current_key) || this.getEdgeMetadata().containsKey(this.current_key))) {
            throw new SAXNotSupportedException("'data' tag's key specification must reference a defined key");
        }
    }

    protected void createKey(Attributes atts) throws SAXNotSupportedException {
        Map<String, String> key_atts = this.getAttributeMap(atts);
        String id = key_atts.remove("id");
        String for_type = key_atts.remove("for");
        if (for_type == null || for_type.equals("") || for_type.equals("all")) {
            this.vertex_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
            this.edge_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
            this.graph_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
            this.key_type = KeyType.ALL;
        } else {
            TagState type = (TagState)((Object)this.tag_state.get(for_type));
            switch (type) {
                case VERTEX: {
                    this.vertex_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
                    this.key_type = KeyType.VERTEX;
                    break;
                }
                case EDGE: 
                case HYPEREDGE: {
                    this.edge_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
                    this.key_type = KeyType.EDGE;
                    break;
                }
                case GRAPH: {
                    this.graph_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
                    this.key_type = KeyType.GRAPH;
                    break;
                }
                default: {
                    throw new SAXNotSupportedException("Invalid metadata target type: " + for_type);
                }
            }
        }
        this.current_key = id;
    }

    protected void createVertex(Attributes atts) throws SAXNotSupportedException {
        Map<String, String> vertex_atts = this.getAttributeMap(atts);
        String id = vertex_atts.remove("id");
        if (id == null) {
            throw new SAXNotSupportedException("node attribute list missing 'id': " + atts.toString());
        }
        Object v = this.vertex_ids.getKey(id);
        if (v != null) {
            throw new SAXNotSupportedException("Node id \"" + id + " is a duplicate of an existing node ID");
        }
        v = this.vertex_factory != null ? this.vertex_factory.create() : id;
        this.vertex_ids.put((String)v, id);
        this.current_graph.addVertex(v);
        this.addExtraData(vertex_atts, this.vertex_metadata, v);
        this.current_vertex = v;
    }

    protected void createEdge(Attributes atts, TagState state) throws SAXNotSupportedException {
        Object e;
        Map<String, String> edge_atts = this.getAttributeMap(atts);
        String id = edge_atts.remove("id");
        if (this.edge_factory != null) {
            e = this.edge_factory.create();
        } else if (id != null) {
            e = id;
        } else {
            throw new IllegalArgumentException("If no edge factory is supplied, edge id may not be null: " + edge_atts);
        }
        if (id != null) {
            if (this.edge_ids.containsKey(e)) {
                throw new SAXNotSupportedException("Edge id \"" + id + "\" is a duplicate of an existing edge ID");
            }
            this.edge_ids.put(e, id);
        }
        if (state == TagState.EDGE) {
            this.assignEdgeSourceTarget(e, atts, edge_atts);
        }
        this.addExtraData(edge_atts, this.edge_metadata, e);
        this.current_edge = e;
    }

    protected void assignEdgeSourceTarget(E e, Attributes atts, Map<String, String> edge_atts) throws SAXNotSupportedException {
        EdgeType edge_type;
        String source_id = edge_atts.remove("source");
        if (source_id == null) {
            throw new SAXNotSupportedException("edge attribute list missing 'source': " + atts.toString());
        }
        V source = this.vertex_ids.getKey(source_id);
        if (source == null) {
            throw new SAXNotSupportedException("specified 'source' attribute \"" + source_id + "\" does not match any node ID");
        }
        String target_id = edge_atts.remove("target");
        if (target_id == null) {
            throw new SAXNotSupportedException("edge attribute list missing 'target': " + atts.toString());
        }
        V target = this.vertex_ids.getKey(target_id);
        if (target == null) {
            throw new SAXNotSupportedException("specified 'target' attribute \"" + target_id + "\" does not match any node ID");
        }
        String directed = edge_atts.remove("directed");
        if (directed == null) {
            edge_type = this.default_edgetype;
        } else if (directed.equals("true")) {
            edge_type = EdgeType.DIRECTED;
        } else if (directed.equals("false")) {
            edge_type = EdgeType.UNDIRECTED;
        } else {
            throw new SAXNotSupportedException("Unrecognized edge direction specifier 'direction=\"" + directed + "\"': " + "source: " + source_id + ", target: " + target_id);
        }
        if (this.current_graph instanceof Graph) {
            ((Graph)this.current_graph).addEdge(e, source, target, edge_type);
        } else {
            this.current_graph.addEdge(e, new Pair<V>(source, target));
        }
    }

    public BidiMap<V, String> getVertexIDs() {
        return this.vertex_ids;
    }

    public BidiMap<E, String> getEdgeIDs() {
        return this.edge_ids;
    }

    public Map<String, GraphMLMetadata<G>> getGraphMetadata() {
        return this.graph_metadata;
    }

    public Map<String, GraphMLMetadata<V>> getVertexMetadata() {
        return this.vertex_metadata;
    }

    public Map<String, GraphMLMetadata<E>> getEdgeMetadata() {
        return this.edge_metadata;
    }

    public Map<G, String> getGraphDescriptions() {
        return this.graph_desc;
    }

    public Map<V, String> getVertexDescriptions() {
        return this.vertex_desc;
    }

    public Map<E, String> getEdgeDescriptions() {
        return this.edge_desc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum KeyType {
        NONE,
        VERTEX,
        EDGE,
        GRAPH,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TagState {
        NO_TAG,
        VERTEX,
        EDGE,
        HYPEREDGE,
        ENDPOINT,
        GRAPH,
        DATA,
        KEY,
        DESC,
        DEFAULT_KEY,
        GRAPHML,
        OTHER;

    }
}

