#!/usr/bin/python

import statistics
import sys
import re
from re import split
from math import sqrt
import os

basedir = sys.argv[1]

filesList = [basedir + file for file in os.listdir(basedir) if (re.match('.*dat$', file) and not re.match('^output.*', file))]

results = []
for file in filesList:
    inp = open(file,"r")
    values = []
    for line in inp.readlines():
        values.append(float(line))
    inp.close()
    print "File ",file," acquisito."
    results.append(statistics.mean(values))
variance = statistics.variance(results, mode = "Unbiased")
confidence = sqrt(variance / len(results)) * 1.6449
print "Average: ",statistics.mean(results)," Confidence interval: ",confidence
