#!/bin/bash
index=0
execution=10
file=../../reteUtentiMikeHidden.arff
lib=../../lib/*
bin=build/classes
curDir=`pwd`

outputFolder=$curDir/output/metis/
prefixOutput=metis
random=false

suffixOutput=.xml

cd $bin
while [ "$index" -lt "$execution" ]
do
  echo "Clustering task #$index"
  fileOutput=$outputFolder$prefixOutput$index$suffixOutput
  logOutput=$outputFolder$prefixOutput$index.log
  java -Xms256m -Xmx1024m -cp .:$lib weka.clusterers.MetisMQIClusterer -V 0 -R $random -S 100 -N 30 -o $fileOutput -t $file >> $logOutput
  index=`expr $index + 1`
done
cd $curDir

echo

exit 0
