/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.AbstractEdgeShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.ConstantDirectionalEdgeValueTransformer;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Transformer;

public class EdgeLabelDemo
extends JApplet {
    private static final long serialVersionUID = -6077157664507049647L;
    Graph<Integer, Number> graph;
    VisualizationViewer<Integer, Number> vv;
    VertexLabelRenderer vertexLabelRenderer;
    EdgeLabelRenderer edgeLabelRenderer;
    ScalingControl scaler = new CrossoverScalingControl();

    public EdgeLabelDemo() {
        this.graph = new SparseMultigraph();
        Integer[] v = this.createVertices(3);
        this.createEdges(v);
        CircleLayout layout = new CircleLayout(this.graph);
        this.vv = new VisualizationViewer((Layout)layout, new Dimension(600, 400));
        this.vv.setBackground(Color.white);
        this.vertexLabelRenderer = this.vv.getRenderContext().getVertexLabelRenderer();
        this.edgeLabelRenderer = this.vv.getRenderContext().getEdgeLabelRenderer();
        Transformer<Number, String> stringer = new Transformer<Number, String>(){

            @Override
            public String transform(Number e) {
                return "Edge:" + EdgeLabelDemo.this.graph.getEndpoints(e).toString();
            }
        };
        this.vv.getRenderContext().setEdgeLabelTransformer((Transformer)stringer);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new PickableEdgePaintTransformer((PickedInfo)this.vv.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.cyan));
        this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)new PickableVertexPaintTransformer((PickedInfo)this.vv.getPickedVertexState(), (Paint)Color.red, (Paint)Color.yellow));
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        Container content = this.getContentPane();
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EdgeLabelDemo.this.scaler.scale(EdgeLabelDemo.this.vv, 1.1f, EdgeLabelDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EdgeLabelDemo.this.scaler.scale(EdgeLabelDemo.this.vv, 0.9090909f, EdgeLabelDemo.this.vv.getCenter());
            }
        });
        ButtonGroup radio = new ButtonGroup();
        JRadioButton lineButton = new JRadioButton("Line");
        lineButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EdgeLabelDemo.this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
                    EdgeLabelDemo.this.vv.repaint();
                }
            }
        });
        JRadioButton quadButton = new JRadioButton("QuadCurve");
        quadButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EdgeLabelDemo.this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.QuadCurve());
                    EdgeLabelDemo.this.vv.repaint();
                }
            }
        });
        JRadioButton cubicButton = new JRadioButton("CubicCurve");
        cubicButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EdgeLabelDemo.this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.CubicCurve());
                    EdgeLabelDemo.this.vv.repaint();
                }
            }
        });
        radio.add(lineButton);
        radio.add(quadButton);
        radio.add(cubicButton);
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        JCheckBox rotate = new JCheckBox("<html><center>EdgeType<p>Parallel</center></html>");
        rotate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AbstractButton b = (AbstractButton)e.getSource();
                EdgeLabelDemo.this.edgeLabelRenderer.setRotateEdgeLabels(b.isSelected());
                EdgeLabelDemo.this.vv.repaint();
            }
        });
        rotate.setSelected(true);
        MutableDirectionalEdgeValue mv = new MutableDirectionalEdgeValue(0.5, 0.7);
        this.vv.getRenderContext().setEdgeLabelClosenessTransformer((Transformer)((Object)mv));
        JSlider directedSlider = new JSlider(mv.getDirectedModel()){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width /= 2;
                return d;
            }
        };
        JSlider undirectedSlider = new JSlider(mv.getUndirectedModel()){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width /= 2;
                return d;
            }
        };
        JSlider edgeOffsetSlider = new JSlider(0, 50){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width /= 2;
                return d;
            }
        };
        edgeOffsetSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider s = (JSlider)e.getSource();
                AbstractEdgeShapeTransformer aesf = (AbstractEdgeShapeTransformer)EdgeLabelDemo.this.vv.getRenderContext().getEdgeShapeTransformer();
                aesf.setControlOffsetIncrement((float)s.getValue());
                EdgeLabelDemo.this.vv.repaint();
            }
        });
        Box controls = Box.createHorizontalBox();
        JPanel zoomPanel = new JPanel(new GridLayout(0, 1));
        zoomPanel.setBorder(BorderFactory.createTitledBorder("Scale"));
        zoomPanel.add(plus);
        zoomPanel.add(minus);
        JPanel edgePanel = new JPanel(new GridLayout(0, 1));
        edgePanel.setBorder(BorderFactory.createTitledBorder("EdgeType Type"));
        edgePanel.add(lineButton);
        edgePanel.add(quadButton);
        edgePanel.add(cubicButton);
        JPanel rotatePanel = new JPanel();
        rotatePanel.setBorder(BorderFactory.createTitledBorder("Alignment"));
        rotatePanel.add(rotate);
        JPanel labelPanel = new JPanel(new BorderLayout());
        JPanel sliderPanel = new JPanel(new GridLayout(3, 1));
        JPanel sliderLabelPanel = new JPanel(new GridLayout(3, 1));
        JPanel offsetPanel = new JPanel(new BorderLayout());
        offsetPanel.setBorder(BorderFactory.createTitledBorder("Offset"));
        sliderPanel.add(directedSlider);
        sliderPanel.add(undirectedSlider);
        sliderPanel.add(edgeOffsetSlider);
        sliderLabelPanel.add(new JLabel("Directed", 4));
        sliderLabelPanel.add(new JLabel("Undirected", 4));
        sliderLabelPanel.add(new JLabel("Edges", 4));
        offsetPanel.add((Component)sliderLabelPanel, "West");
        offsetPanel.add(sliderPanel);
        labelPanel.add(offsetPanel);
        labelPanel.add((Component)rotatePanel, "West");
        JPanel modePanel = new JPanel(new GridLayout(2, 1));
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(graphMouse.getModeComboBox());
        controls.add(zoomPanel);
        controls.add(edgePanel);
        controls.add(labelPanel);
        controls.add(modePanel);
        content.add((Component)controls, "South");
        quadButton.setSelected(true);
    }

    private Integer[] createVertices(int count) {
        Integer[] v = new Integer[count];
        for (int i = 0; i < count; ++i) {
            v[i] = new Integer(i);
            this.graph.addVertex(v[i]);
        }
        return v;
    }

    void createEdges(Integer[] v) {
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[0], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[1], v[0], EdgeType.DIRECTED);
        this.graph.addEdge((Number)new Double(Math.random()), v[1], v[2]);
        this.graph.addEdge((Number)new Double(Math.random()), v[1], v[2]);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        Container content = frame.getContentPane();
        content.add(new EdgeLabelDemo());
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MutableDirectionalEdgeValue
    extends ConstantDirectionalEdgeValueTransformer<Integer, Number> {
        BoundedRangeModel undirectedModel;
        BoundedRangeModel directedModel;

        public MutableDirectionalEdgeValue(double undirected, double directed) {
            super(undirected, directed);
            this.undirectedModel = new DefaultBoundedRangeModel(5, 0, 0, 10);
            this.directedModel = new DefaultBoundedRangeModel(7, 0, 0, 10);
            this.undirectedModel.setValue((int)(undirected * 10.0));
            this.directedModel.setValue((int)(directed * 10.0));
            this.undirectedModel.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MutableDirectionalEdgeValue.this.setUndirectedValue(new Double((float)MutableDirectionalEdgeValue.this.undirectedModel.getValue() / 10.0f));
                    EdgeLabelDemo.this.vv.repaint();
                }
            });
            this.directedModel.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MutableDirectionalEdgeValue.this.setDirectedValue(new Double((float)MutableDirectionalEdgeValue.this.directedModel.getValue() / 10.0f));
                    EdgeLabelDemo.this.vv.repaint();
                }
            });
        }

        public BoundedRangeModel getDirectedModel() {
            return this.directedModel;
        }

        public BoundedRangeModel getUndirectedModel() {
            return this.undirectedModel;
        }
    }
}

